
@php
    $auth_user= authSession();
@endphp
{{ Form::open(['route' => ['question.destroy', $question->id], 'method' => 'delete','data--submit'=>'question'.$question->id]) }}
<div class="d-flex justify-content-end align-items-center">
    @if(!$question->trashed())
        @if($auth_user->can('question edit'))
        <a class="mr-2" href="{{ route('question.create',['id' => $question->id]) }}" title="{{ __('messages.update_form_title',['form' => __('messages.question') ]) }}"><i class="fas fa-pen text-primary"></i></a>
        @endif

        @if($auth_user->can('question delete'))
        <a class="mr-2" href="javascript:void(0)" data--submit="question{{$question->id}}" 
            data--confirmation='true' data-title="{{ __('messages.delete_form_title',['form'=>  __('messages.question') ]) }}"
            title="{{ __('messages.delete_form_title',['form'=>  __('messages.question') ]) }}"
            data-message='{{ __("messages.delete_msg") }}'>
            <i class="far fa-trash-alt text-danger"></i>
        </a>
        @endif
    @endif
    @if(auth()->user()->hasAnyRole(['admin']) && $question->trashed())
        <a href="{{ route('question.action',['id' => $question->id, 'type' => 'restore']) }}"
            title="{{ __('messages.restore_form_title',['form' => __('messages.question') ]) }}"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="{{ __('messages.restore_form_title',['form'=>  __('messages.question') ]) }}"
            data-message='{{ __("messages.restore_msg") }}'
            data-datatable="reload"
            class="mr-2">
            <i class="fas fa-redo text-secondary"></i>
        </a>
        <a href="{{ route('question.action',['id' => $question->id, 'type' => 'forcedelete']) }}"
            title="{{ __('messages.forcedelete_form_title',['form' => __('messages.question') ]) }}"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="{{ __('messages.forcedelete_form_title',['form'=>  __('messages.question') ]) }}"
            data-message='{{ __("messages.forcedelete_msg") }}'
            data-datatable="reload"
            class="mr-2">
            <i class="far fa-trash-alt text-danger"></i>
        </a>
    @endif
</div>
{{ Form::close() }}