<x-master-layout>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card card-block card-stretch">
                    <div class="card-body p-0">
                        <div class="d-flex justify-content-between align-items-center p-3 flex-wrap gap-3">
                            <h5 class="font-weight-bold">{{ $pageTitle ?? trans('messages.list') }}</h5>
                            @if($auth_user->can('blog list'))
                            <a href="{{ route('blog.index') }}" class="float-right btn btn-sm btn-primary"><i class="fa fa-angle-double-left"></i> {{ __('messages.back') }}</a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        {{ Form::model($questionData,['method' => 'POST','route'=>'question.store', 'enctype'=>'multipart/form-data', 'data-toggle'=>"validator" ,'id'=>'question'] ) }}
                        {{ Form::hidden('id') }}
                        <div class="row">
                            <div class="form-group col-md-4">
                                {{ Form::label('title',trans('messages.title').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false ) }}
                                {{ Form::text('title',old('title'),['placeholder' => trans('messages.title'),'class' =>'form-control','required']) }}
                                <small class="help-block with-errors text-danger"></small>
                            </div>
                            @if(auth()->user()->hasAnyRole(['admin','demo_admin']))
                            <div class="form-group col-md-4">
                                {{ Form::label('name', __('messages.select_name',[ 'select' => __('messages.author') ]),['class'=>'form-control-label'],false) }}
                                <br />
                                {{ Form::select('author_id', [ optional($questionData->author)->id => optional($questionData->author)->display_name ], optional($questionData->author)->id, [
                                            'class' => 'select2js form-group',
                                            'id' => 'author_id',
                                            'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.author') ]),
                                            'data-ajax--url' => route('ajax-list', ['type' => 'provider']),
                                        ]) }}
                            </div>
                            @endif
                            <div class="form-group col-md-4">
                                {{ Form::label('status',trans('messages.status').' <span class="text-danger">*</span>',['class'=>'form-control-label'],false) }}
                                {{ Form::select('status',['1' => __('messages.active') , '0' => __('messages.inactive') ],old('status'),[ 'id' => 'role' ,'class' =>'form-control select2js','required']) }}
                            </div>

                            <div class="form-group col-md-12">
                                {{ Form::label('description',trans('messages.description'), ['class' => 'form-control-label']) }}
                                {{-- Form::textarea('description', null, ['class'=>"form-control textarea" , 'rows'=>3  , 'placeholder'=> __('messages.description') ]) --}}
                                {{ Form::textarea('description', null, ['class'=> 'form-control tinymce-description', 'rows'=>3 , 'placeholder'=> __('messages.description') ]) }}
                            </div>
                        </div>
                        <div class="row">
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    {{ Form::checkbox('is_featured', $questionData->is_featured, null, ['class' => 'custom-control-input' , 'id' => 'is_featured' ]) }}
                                    <label class="custom-control-label" for="is_featured">{{ __('messages.set_as_featured')  }}
                                    </label>
                                </div>
                            </div>
                        </div>
                        {{ Form::submit( trans('messages.save'), ['class'=>'btn btn-md btn-primary float-right']) }}
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        
        
    </script>
@section('bottom_script')
<script>
    function preview() {
        blog_image_preview.src = URL.createObjectURL(event.target.files[0]);
    }

    (function($) {
        $(document).ready(function(){
            tinymceEditor('.tinymce-description',' ',function (ed) {

            }, 450)
        });
    })(jQuery);
</script>
@endsection
</x-master-layout>