<?php if (isset($component)) { $__componentOriginalc6e081c8432fe1dd6b4e43af4871c93447ee9b23 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\MasterLayout::class, []); ?>
<?php $component->withName('master-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card card-block card-stretch">
                    <div class="card-body p-0">
                        <div class="d-flex justify-content-between align-items-center p-3 flex-wrap gap-3">
                            <h5 class="font-weight-bold"><?php echo e($pageTitle ?? trans('messages.list')); ?></h5>
                            <?php if($auth_user->can('blog list')): ?>
                            <a href="<?php echo e(route('blog.index')); ?>" class="float-right btn btn-sm btn-primary"><i class="fa fa-angle-double-left"></i> <?php echo e(__('messages.back')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <?php echo e(Form::model($blogdata,['method' => 'POST','route'=>'blog.store', 'enctype'=>'multipart/form-data', 'data-toggle'=>"validator" ,'id'=>'blog'] )); ?>

                        <?php echo e(Form::hidden('id')); ?>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <?php echo e(Form::label('title',trans('messages.title').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

                                <?php echo e(Form::text('title',old('title'),['placeholder' => trans('messages.title'),'class' =>'form-control','required'])); ?>

                                <small class="help-block with-errors text-danger"></small>
                            </div>
                            <?php if(auth()->user()->hasAnyRole(['admin','demo_admin'])): ?>
                            <div class="form-group col-md-4">
                                <?php echo e(Form::label('name', __('messages.select_name',[ 'select' => __('messages.author') ]),['class'=>'form-control-label'],false)); ?>

                                <br />
                                <?php echo e(Form::select('author_id', [ optional($blogdata->author)->id => optional($blogdata->author)->display_name ], optional($blogdata->author)->id, [
                                            'class' => 'select2js form-group',
                                            'id' => 'author_id',
                                            'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.author') ]),
                                            'data-ajax--url' => route('ajax-list', ['type' => 'provider']),
                                        ])); ?>

                            </div>
                            <?php endif; ?>
                            <div class="form-group col-md-4">
                                <?php echo e(Form::label('status',trans('messages.status').' <span class="text-danger">*</span>',['class'=>'form-control-label'],false)); ?>

                                <?php echo e(Form::select('status',['1' => __('messages.active') , '0' => __('messages.inactive') ],old('status'),[ 'id' => 'role' ,'class' =>'form-control select2js','required'])); ?>

                            </div>

                            <div class="form-group col-md-4">
                                <label class="form-control-label" for="blog_attachment"><?php echo e(__('messages.image')); ?> <span class="text-danger">*</span> </label>
                                <div class="custom-file">
                                    <input type="file" name="blog_attachment[]" class="custom-file-input" data-file-error="<?php echo e(__('messages.files_not_allowed')); ?>" multiple>
                                    <label class="custom-file-label upload-label"><?php echo e(__('messages.choose_file',['file' =>  __('messages.attachments') ])); ?></label>
                                </div>
                            </div>
                            <div class="row blog_attachment_div">
                                <div class="col-md-12">
                                    <?php if(getMediaFileExit($blogdata, 'blog_attachment')): ?>
                                    <?php
                                    $attchments = $blogdata->getMedia('blog_attachment');
                                    $file_extention = config('constant.IMAGE_EXTENTIONS');
                                    ?>
                                    <div class="border-left-2">
                                        <p class="ml-2"><b><?php echo e(__('messages.attached_files')); ?></b></p>
                                        <div class="ml-2 my-3">
                                            <div class="row">
                                                <?php $__currentLoopData = $attchments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attchment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php 
                                                    $extention = in_array(strtolower(imageExtention($attchment->getFullUrl())), $file_extention);
                                                ?>
                                                <div class="col-md-2 pr-10 text-center galary file-gallary-<?php echo e($blogdata->id); ?>" data-gallery=".file-gallary-<?php echo e($blogdata->id); ?>" id="blog_attachment_preview_<?php echo e($attchment->id); ?>">
                                                    <?php if($extention): ?>
                                                    <a id="attachment_files" href="<?php echo e($attchment->getFullUrl()); ?>" class="list-group-item-action attachment-list" target="_blank">
                                                        <img src="<?php echo e($attchment->getFullUrl()); ?>" class="attachment-image" alt="">
                                                    </a>
                                                    <?php else: ?>
                                                    <a id="attachment_files" class="video list-group-item-action attachment-list" href="<?php echo e($attchment->getFullUrl()); ?>">
                                                        <img src="<?php echo e(asset('images/file.png')); ?>" class="attachment-file">
                                                    </a>
                                                    <?php endif; ?>
                                                    <a class="text-danger remove-file" href="<?php echo e(route('remove.file', ['id' => $attchment->id, 'type' => 'blog_attachment'])); ?>" data--submit="confirm_form" data--confirmation='true' data--ajax="true" data-toggle="tooltip" title='<?php echo e(__("messages.remove_file_title" , ["name" =>  __("messages.attachments") ] )); ?>' data-title='<?php echo e(__("messages.remove_file_title" , ["name" =>  __("messages.attachments") ] )); ?>' data-message='<?php echo e(__("messages.remove_file_msg")); ?>'>
                                                        <i class="ri-close-circle-line"></i>
                                                    </a>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <?php echo e(Form::label('description',trans('messages.description'), ['class' => 'form-control-label'])); ?>

                                
                                <?php echo e(Form::textarea('description', null, ['class'=> 'form-control tinymce-description', 'rows'=>3 , 'placeholder'=> __('messages.description') ])); ?>

                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <?php echo e(Form::checkbox('is_featured', $blogdata->is_featured, null, ['class' => 'custom-control-input' , 'id' => 'is_featured' ])); ?>

                                    <label class="custom-control-label" for="is_featured"><?php echo e(__('messages.set_as_featured')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                        <?php echo e(Form::submit( trans('messages.save'), ['class'=>'btn btn-md btn-primary float-right'])); ?>

                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->startSection('bottom_script'); ?>
<script>
    function preview() {
        blog_image_preview.src = URL.createObjectURL(event.target.files[0]);
    }

    (function($) {
        $(document).ready(function(){
            tinymceEditor('.tinymce-description',' ',function (ed) {

            }, 450)
        });
    })(jQuery);
</script>
<?php $__env->stopSection(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc6e081c8432fe1dd6b4e43af4871c93447ee9b23)): ?>
<?php $component = $__componentOriginalc6e081c8432fe1dd6b4e43af4871c93447ee9b23; ?>
<?php unset($__componentOriginalc6e081c8432fe1dd6b4e43af4871c93447ee9b23); ?>
<?php endif; ?><?php /**PATH /var/www/html/dashincare/resources/views/blog/create.blade.php ENDPATH**/ ?>