
<?php
    $auth_user= authSession();
?>
<?php echo e(Form::open(['route' => ['announcement.destroy', $announcement->id], 'method' => 'delete','data--submit'=>'announcement'.$announcement->id])); ?>

<div class="d-flex justify-content-end align-items-center">
    <?php if(!$announcement->trashed()): ?>
        <?php if($auth_user->can('announcement edit')): ?>
        <a class="mr-2" href="<?php echo e(route('announcement.create',['id' => $announcement->id])); ?>" title="<?php echo e(__('messages.update_form_title',['form' => __('messages.announcement') ])); ?>"><i class="fas fa-pen text-primary"></i></a>
        <?php endif; ?>

        <?php if($auth_user->can('announcement delete')): ?>
        <a class="mr-2" href="javascript:void(0)" data--submit="announcement<?php echo e($announcement->id); ?>" 
            data--confirmation='true' data-title="<?php echo e(__('messages.delete_form_title',['form'=>  __('messages.announcement') ])); ?>"
            title="<?php echo e(__('messages.delete_form_title',['form'=>  __('messages.announcement') ])); ?>"
            data-message='<?php echo e(__("messages.delete_msg")); ?>'>
            <i class="far fa-trash-alt text-danger"></i>
        </a>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(auth()->user()->hasAnyRole(['admin']) && $announcement->trashed()): ?>
        <a href="<?php echo e(route('announcement.action',['id' => $announcement->id, 'type' => 'restore'])); ?>"
            title="<?php echo e(__('messages.restore_form_title',['form' => __('messages.announcement') ])); ?>"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="<?php echo e(__('messages.restore_form_title',['form'=>  __('messages.announcement') ])); ?>"
            data-message='<?php echo e(__("messages.restore_msg")); ?>'
            data-datatable="reload"
            class="mr-2">
            <i class="fas fa-redo text-secondary"></i>
        </a>
        <a href="<?php echo e(route('announcement.action',['id' => $announcement->id, 'type' => 'forcedelete'])); ?>"
            title="<?php echo e(__('messages.forcedelete_form_title',['form' => __('messages.announcement') ])); ?>"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="<?php echo e(__('messages.forcedelete_form_title',['form'=>  __('messages.announcement') ])); ?>"
            data-message='<?php echo e(__("messages.forcedelete_msg")); ?>'
            data-datatable="reload"
            class="mr-2">
            <i class="far fa-trash-alt text-danger"></i>
        </a>
    <?php endif; ?>
</div>
<?php echo e(Form::close()); ?><?php /**PATH /var/www/html/dashincare/resources/views/announcement/action.blade.php ENDPATH**/ ?>