<?php echo e(Form::model($payment_data, ['method' => 'POST','route' => ['paymentsettingsUpdates'],'enctype'=>'multipart/form-data','data-toggle'=>'validator'])); ?>


<?php echo e(Form::hidden('id', null, array('placeholder' => 'id','class' => 'form-control'))); ?>

<?php echo e(Form::hidden('type', $tabpage, array('placeholder' => 'id','class' => 'form-control'))); ?>

 <div class="row">
    <div class="form-group col-md-12" >
        <label for="enable_sadad"><?php echo e(__('messages.payment_on',['gateway'=>__('messages.sadad')])); ?></label>
        <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" name="status" id="enable_sadad" <?php echo e(!empty($payment_data) && $payment_data->status == 1 ? 'checked' : ''); ?>>
            <label class="custom-control-label" for="enable_sadad"></label>
        </div>
    </div>
 </div>
 <div class="row" id='enable_sadad_payment'>
    <div class="form-group col-md-12">
        <label class="form-control-label"><?php echo e(__('messages.payment_option',['gateway'=>__('messages.sadad')])); ?></label><br/>
        <div class="form-check-inline">
            <label class="form-check-label">
                <input type="radio" class="form-check-input is_test" value="on" name="is_test" data-type="is_test_mode" <?php echo e(!empty($payment_data) && $payment_data->is_test == 1 ? 'checked' :''); ?>><?php echo e(__('messages.is_test_mode')); ?>

            </label>
        </div>
        <div class="form-check-inline">
            <label class="form-check-label">
                <input type="radio" class="form-check-input is_test" value="off" name="is_test" data-type="is_live_mode" <?php echo e(!empty($payment_data) && $payment_data->is_test == 0 ? 'checked' :''); ?>><?php echo e(__('messages.is_live_mode')); ?>

            </label>
        </div>
        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col-md-12">
        <?php echo e(Form::label('title',trans('messages.gateway_name').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('title',old('title'),['id'=>'title','placeholder' => trans('messages.title'),'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col-md-12">
        <?php echo e(Form::label('sadad_id',trans('messages.sadad_id').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('sadad_id',old('sadad_id'),['id'=>'sadad_id','placeholder' => trans('messages.sadad_id'),'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col-md-12">
        <?php echo e(Form::label('sadad_key',trans('messages.sadad_key').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('sadad_key',old('sadad_key'),['id'=>'sadad_key','placeholder' => trans('messages.sadad_key'),'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col-md-12">
        <?php echo e(Form::label('sadad_domain',trans('messages.sadad_domain').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('sadad_domain',old('sadad_domain'),['id'=>'sadad_domain','placeholder' => trans('messages.sadad_domain'),'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
 </div>
<?php echo e(Form::submit(__('messages.save'), ['class'=>"btn btn-md btn-primary float-md-right"])); ?>

<?php echo e(Form::close()); ?>

<script>
var enable_sadad = $("input[name='status']").prop('checked');
checkPaymentTabOption(enable_sadad);

$('#enable_sadad').change(function(){
    value = $(this).prop('checked') == true ? true : false;
    checkPaymentTabOption(value);
});
function checkPaymentTabOption(value){
    if(value == true){
        $('#enable_sadad_payment').removeClass('d-none');
    }else{
        $('#enable_sadad_payment').addClass('d-none');
    }
}

var get_value = $('input[name="is_test"]:checked').data("type");
getConfig(get_value)
$('.is_test').change(function(){
    value = $(this).prop('checked') == true ? true : false;
    type = $(this).data("type");
    getConfig(type)

});

function getConfig(type){
    var _token   = $('meta[name="csrf-token"]').attr('content');
    var page =  "<?php echo e($tabpage); ?>";
    $.ajax({
        url: "/get_payment_config",
        type:"POST",
        data:{
          type:type,
          page:page,
          _token: _token
        },
        success:function(response){
            var obj = '';
            var sadad_id=sadad_key=sadad_domain=title = '';

            if(response){
            
                if(response.data.type == 'is_test_mode'){
                    obj = JSON.parse(response.data.value);
                }else{
                    obj = JSON.parse(response.data.live_value);
                }

                if(response.data.title != ''){
                    title = response.data.title
                }
                
                if(obj !== null){
                    var sadad_id = obj.sadad_id;
                    var sadad_key = obj.sadad_key;
                    var sadad_domain = obj.sadad_domain;
                }

                $('#sadad_id').val(sadad_id)
                $('#sadad_key').val(sadad_key)
                $('#sadad_domain').val(sadad_domain)
                $('#title').val(title)
            
            }
        },
        error: function(error) {
         console.log(error);
        }
    });
}

</script><?php /**PATH /var/www/html/dashincare/resources/views/paymentgateway/sadad.blade.php ENDPATH**/ ?>