<div class="col-md-12">
    <div class="row ">
		<div class="col-md-3">
			<div class="user-sidebar">
				<div class="user-body user-profile text-center">
					<div class="user-img">
						<img class="rounded-circle avatar-100 image-fluid profile_image_preview" src="<?php echo e(getSingleMedia($user_data,'profile_image', null)); ?>" alt="profile-pic">
					</div>
					<div class="sideuser-info">
						<span class="mb-2"><?php echo e($user_data->display_name); ?></span>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-9">
			<div class="user-content">
				<?php echo e(Form::model($user_data, ['route'=>'updateProfile','method' => 'POST','data-toggle'=>"validator" , 'enctype'=> 'multipart/form-data','id' => 'user-form'])); ?>

					<input type="hidden" name="profile" value="profile">
					<?php echo e(Form::hidden('username')); ?>

					<?php echo e(Form::hidden('email')); ?>

				    <?php echo e(Form::hidden('id', null, array('placeholder' => 'id','class' => 'form-control'))); ?>

				    <div class="row ">
				        
						<div class="form-group col-md-6">
							<?php echo e(Form::label('first_name',__('姓名').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

							<?php echo e(Form::text('first_name',old('first_name'),['placeholder' => __('姓名'),'class' =>'form-control','required'])); ?>

							<small class="help-block with-errors text-danger"></small>
						</div>
						
						
						
						<div class="form-group col-md-6">
							<?php echo e(Form::label('username',__('messages.username').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

							<?php echo e(Form::text('username',old('username'),['placeholder' => __('messages.username'),'class' =>'form-control','required'])); ?>

							<small class="help-block with-errors text-danger"></small>
						</div>
						<?php if(auth()->user()->hasRole('provider')): ?>
						<div class="form-group col-md-6">
							<?php echo e(Form::label('designation',__('messages.designation').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

							<?php echo e(Form::text('designation',old('designation'),['placeholder' => __('messages.designation'),'class' =>'form-control','required'])); ?>

							<small class="help-block with-errors text-danger"></small>
						</div>
						<?php endif; ?>
						
						
						<div class="col-6 form-group">
							<?php echo e(Form::label('name', __('messages.state',[ 'select' => __('messages.state') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false)); ?>

							<select id="county" required class="form-control county" name="state_id">
								<option value="">請選擇</option>
								<?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($city['value']); ?>" <?php echo e($city['value'] === $user_data->state_id ? 'selected' : ''); ?>><?php echo e($city['text']); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
						</div>

						<div class="col-6 form-group">
								<?php echo e(Form::label('name', __('messages.city',[ 'select' => __('messages.city') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false)); ?>

								<select id="city" required class="form-control city" name="city_id"></select>
						</div>

						

						<div class="form-group col-md-6">
							<?php echo e(Form::label('email',__('messages.email').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

							<?php echo e(Form::email('email',old('email'),['placeholder' => __('messages.email'),'class' =>'form-control','required'])); ?>

							<small class="help-block with-errors text-danger"></small>
						</div>

				        <div class="form-group col-md-6">
							<?php echo e(Form::label('contact_number',__('messages.contact_number').' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

							<?php echo e(Form::text('contact_number',old('contact_number'),['placeholder' => __('messages.contact_number'),'class' =>'form-control','required'])); ?>

							<small class="help-block with-errors text-danger"></small>
						</div>
						

						
					
						
				   
				        <div class="form-group col-md-6">
							<?php echo e(Form::label('profile_image',__('messages.choose_profile_image'),['class'=>'form-control-label'] )); ?>

							<div class="custom-file">
								<?php echo e(Form::file('profile_image', ['class'=>"custom-file-input custom-file-input-sm detail" , 'id'=>"profile_image" , 'lang'=>"en" , 'accept'=>"image/*"])); ?>

								<label class="custom-file-label upload-label" id="imagelabel" for="profile_image"><?php echo e(__('messages.profile_image')); ?></label>
							</div> 
				        </div>

						<?php if(auth()->user()->hasAnyRole(['admin','demo_admin','provider', 'freelancer'])): ?>
						<div class="form-group col-md-6">
							<?php echo e(Form::label('name', __('messages.select_name',[ 'select' => __('messages.provider_address') ]),['class'=>'form-control-label'],false)); ?>

							<br />
							<select class="select2js form-group gc_service_address" name="gc_service_address[]" id="gc_service_address" multiple data-placeholder="選擇服務範圍">
								<?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($city['value']); ?>" <?php if( $user_data->gc_service_address ): ?> <?php if(in_array($city['value'], $user_data->gc_service_address)): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($city['text']); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
						</div>
						<?php endif; ?>
						

						<div class="form-group col-md-12">
							<?php echo e(Form::label('address',__('messages.address'), ['class' => 'form-control-label'])); ?>

							<?php echo e(Form::textarea('address', null, ['class'=>"form-control textarea" , 'rows'=>1  , 'placeholder'=> __('messages.address') ])); ?>

						</div>
						
						<div class="form-group col-md-12">
							<?php echo e(Form::label('description',__('messages.description'), ['class' => 'form-control-label'])); ?>

							<?php echo e(Form::textarea('description', null, ['class'=>"form-control textarea" , 'rows'=>3  , 'placeholder'=> __('messages.description') ])); ?>

						</div>
				        <div class="col-md-12">
							<?php echo e(Form::submit(__('messages.update'), ['class'=>"btn btn-md btn-primary float-md-right"])); ?>

				        </div>

						
				    </div>
			</div>
		</div>
    </div>
</div>

<script>

// (function($) {
// 	"use strict";
	$(document).ready(function (){
		$('.select2js').select2({
                width: '100%',
				// dropdownParent: $(this).parent()
        });
		var country_id =  "<?php echo e(isset($user_data->country_id) ? $user_data->country_id : 0); ?>";
		var state_id = "<?php echo e(isset($user_data->state_id) ? $user_data->state_id : 0); ?>";
		var city_id = "<?php echo e(isset($user_data->city_id) ? $user_data->city_id : 0); ?>";

		stateName( country_id , state_id);
		$(document).on('change' , '#country_id' , function (){
			var country = $(this).val();
			$('#state_id').empty();
			$('#city_id').empty();
			stateName(country);
		})
		$(document).on('change' , '#state_id' , function (){
			var state = $(this).val();
			$('#city_id').empty();
			cityName(state , city_id);
		})
	function stateName(country , state ="" ){
		var state_route = "<?php echo e(route('ajax-list', [ 'type' => 'state','country_id' =>''])); ?>"+country;
		state_route = state_route.replace('amp;','');

		$.ajax({
			url: state_route,
			success: function(result){
				$('#state_id').select2({
					width: '100%',
					placeholder: "<?php echo e(trans('messages.select_name',['select' => trans('messages.state')])); ?>",
					data: result.results
				});
				if(state != null){
					$("#state_id").val(state).trigger('change');
				}
			}
		});
	}
	function cityName(state , city =""){
		var city_route = "<?php echo e(route('ajax-list', [ 'type' => 'city' ,'state_id' =>''])); ?>"+state;
		city_route = city_route.replace('amp;','');

		$.ajax({
			url: city_route,
			success: function(result){
				$('#city_id').select2({
					width: '100%',
					placeholder: "<?php echo e(trans('messages.select_name',['select' => trans('messages.city')])); ?>",
					data: result.results
				});
				if(city != null || city != 0){
					$("#city_id").val(city).trigger('change');
				}
			}
		});
	}
        $(document).on('change','#profile_image',function(){
			readURL(this);
		})
		function readURL(input) {
			if (input.files && input.files[0]) {
				var reader = new FileReader();

				var res=isImage(input.files[0].name);

				if(res==false){
					var msg = "<?php echo e(__('messages.image_png_gif')); ?>";
					Snackbar.show({text: msg ,pos: 'bottom-center',backgroundColor:'#d32f2f',actionTextColor:'#fff'});
					return false;
				}

				reader.onload = function(e) {
				$('.profile_image_preview').attr('src', e.target.result);
					$("#imagelabel").text((input.files[0].name));
				}

				reader.readAsDataURL(input.files[0]);
			}
		}

		function getExtension(filename) {
			var parts = filename.split('.');
			return parts[parts.length - 1];
		}

		function isImage(filename) {
			var ext = getExtension(filename);
			switch (ext.toLowerCase()) {
			case 'jpg':
			case 'jpeg':
			case 'png':
			case 'gif':
				return true;
			}
			return false;
		}
	})
// })(jQuery);
</script>
<script>
	const county = document.querySelector('#county')
	const city = document.querySelector('#city')

	county.addEventListener('change', getDistrictsData )

	function getDistrictsData( district = 0 ){
		let formData = new FormData();
		formData.append('_token','<?php echo e(csrf_token()); ?>');
		formData.append('city', county.value)
		fetch('<?php echo e(route("getDistrictsData")); ?>',{
			'method':'post',
			'body':formData
		}).then(function (response) {
			return response.json();
		}).then(function (result) {
			city.innerHTML = '';
			result.forEach(function(district) {
				let option = document.createElement('option');
				option.value = district.value;
				option.text = district.text;

				if(district){
					option.selected = true
				}

				city.appendChild(option);
			});
		})
	}
	<?php if($gcAddress): ?>
		getDistrictsData()
	<?php endif; ?>
</script><?php /**PATH /var/www/html/dashincare/resources/views/setting/profile_form.blade.php ENDPATH**/ ?>