
<?php
    $auth_user= authSession();
?>
<?php echo e(Form::open(['route' => ['bank.destroy', $bank->id], 'method' => 'delete','data--submit'=>'bank'.$bank->id])); ?>

<div class="d-flex justify-content-end align-items-center">
    <?php if(!$bank->trashed()): ?>
        <?php if($auth_user->can('bank edit')): ?>
        <a class="mr-2" href="<?php echo e(route('bank.create',['id' => $bank->id])); ?>" title="<?php echo e(__('messages.update_form_title',['form' => __('messages.bank') ])); ?>"><i class="fas fa-pen text-secondary"></i></a>
        <?php endif; ?>

        <?php if($auth_user->can('bank delete')): ?>
        <a class="mr-2" href="javascript:void(0)" data--submit="bank<?php echo e($bank->id); ?>" 
            data--confirmation='true' data-title="<?php echo e(__('messages.delete_form_title',['form'=>  __('messages.bank') ])); ?>"
            title="<?php echo e(__('messages.delete_form_title',['form'=>  __('messages.bank') ])); ?>"
            data-message='<?php echo e(__("messages.delete_msg")); ?>'>
            <i class="far fa-trash-alt text-danger"></i>
        </a>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(auth()->user()->hasAnyRole(['admin']) && $bank->trashed()): ?>
        <a href="<?php echo e(route('bank.action',['id' => $bank->id, 'type' => 'restore'])); ?>"
            title="<?php echo e(__('messages.restore_form_title',['form' => __('messages.bank') ])); ?>"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="<?php echo e(__('messages.restore_form_title',['form'=>  __('messages.bank') ])); ?>"
            data-message='<?php echo e(__("messages.restore_msg")); ?>'
            data-datatable="reload"
            class="mr-2">
            <i class="fas fa-redo text-secondary"></i>
        </a>
        <a href="<?php echo e(route('bank.action',['id' => $bank->id, 'type' => 'forcedelete'])); ?>"
            title="<?php echo e(__('messages.forcedelete_form_title',['form' => __('messages.bank') ])); ?>"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="<?php echo e(__('messages.forcedelete_form_title',['form'=>  __('messages.bank') ])); ?>"
            data-message='<?php echo e(__("messages.forcedelete_msg")); ?>'
            data-datatable="reload"
            class="mr-2">
            <i class="far fa-trash-alt text-danger"></i>
        </a>
    <?php endif; ?>
</div>
<?php echo e(Form::close()); ?><?php /**PATH /var/www/html/dashincare/resources/views/bank/action.blade.php ENDPATH**/ ?>