<?php echo e(Form::model($payment_data, ['method' => 'POST','route' => ['paymentsettingsUpdates'],'enctype'=>'multipart/form-data','data-toggle'=>'validator'])); ?>


<?php echo e(Form::hidden('id', null, array('placeholder' => 'id','class' => 'form-control'))); ?>

<?php echo e(Form::hidden('type', $tabpage, array('placeholder' => 'id','class' => 'form-control'))); ?>

 <div class="row">
    <div class="form-group col-md-12" >
        <label for="enable_neweb"><?php echo e(__('messages.payment_on',['gateway'=>__('messages.neweb')])); ?></label>
        <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" name="status" id="enable_neweb" <?php echo e(!empty($payment_data) && $payment_data->neweb_status == 1 ? 'checked' : ''); ?>>
            <label class="custom-control-label" for="enable_neweb"></label>
        </div>
    </div>
 </div>
 <div class="row" id='enable_neweb_payment'>
    <div class="form-group col col-md-4">
        <?php echo e(Form::label('bank_name', '銀行名稱' .' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('bank_name',old('bank_name'),['id'=>'bank_name','placeholder' => '銀行名稱','class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col col-md-4">
        <?php echo e(Form::label('branch_name', '分行名稱' .' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('branch_name',old('branch_name'),['id'=>'branch_name','placeholder' => '分行名稱','class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col col-md-4">
        <?php echo e(Form::label('account_name', '戶名' .' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('account_name',old('account_name'),['id'=>'account_name','placeholder' => '戶名' ,'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col col-md-4">
        <?php echo e(Form::label('bank_code', '銀行代碼' .' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('bank_code',old('bank_code'),['id'=>'bank_code','placeholder' => '銀行代碼' ,'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
    <div class="form-group col col-md-8">
        <?php echo e(Form::label('account_number', '銀行帳號' .' <span class="text-danger">*</span>',['class'=>'form-control-label'], false )); ?>

        <?php echo e(Form::text('account_number',old('account_number'),['id'=>'account_number','placeholder' => '銀行帳號' ,'class' =>'form-control','required'])); ?>

        <small class="help-block with-errors text-danger"></small>
    </div>
 </div>
<?php echo e(Form::submit(__('messages.save'), ['class'=>"btn btn-md btn-primary float-md-right"])); ?>

<?php echo e(Form::close()); ?>

<script>
var enable_neweb = $("input[name='status']").prop('checked');
checkPaymentTabOption(enable_neweb);

$('#enable_neweb').change(function(){
    value = $(this).prop('checked') == true ? true : false;
    checkPaymentTabOption(value);
});
function checkPaymentTabOption(value){
    if(value == true){
        $('#enable_neweb_payment').addClass('d-none');
    }else{
        $('#enable_neweb_payment').removeClass('d-none');
    }
}

var get_value = $('input[name="is_test"]:checked').data("type");
getConfig(get_value)
$('.is_test').change(function(){
    value = $(this).prop('checked') == true ? true : false;
    type = $(this).data("type");
    getConfig(type)

});

function getConfig(type){
    var _token   = $('meta[name="csrf-token"]').attr('content');
    var page = "<?php echo e($tabpage); ?>";
    $.ajax({
        url: "/get_payment_config",
        type:"POST",
        data:{
          type:type,
          page:page,
          _token: _token
        },
        success:function(response){

            var obj = '';
            var neweb_id=neweb_key=neweb_domain=title = '';

            if(response){
            
                if(response.data.type == 'is_test_mode'){
                    obj = JSON.parse(response.data.value);
                }else{
                    obj = JSON.parse(response.data.live_value);
                }

                if(response.data.title != ''){
                    title = response.data.title
                }
                
                if(obj !== null){
                    var neweb_id = obj.neweb_id;
                    var neweb_key = obj.neweb_key;
                    var neweb_domain = obj.neweb_domain;
                }

                $('#neweb_id').val(neweb_id)
                $('#neweb_key').val(neweb_key)
                $('#neweb_domain').val(neweb_domain)
                $('#title').val(title)
            
            }
        },
        error: function(error) {
         console.log(error);
        }
    });
}

</script><?php /**PATH /var/www/html/dashincare/resources/views/paymentgateway/neweb.blade.php ENDPATH**/ ?>