<!-- Modal -->

<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel"><?php echo e($pageTitle); ?></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
       <?php echo e(Form::open(['route' => 'booking.assigned','method' => 'post','data-toggle'=>"validator"])); ?>

        <div class="modal-body">

           <?php echo e(Form::hidden('id',$bookingdata->id)); ?>

            <div class="row">
                
                <div class="col-md-12 form-group ">
                    <?php echo e(Form::label('handyman_id', __('messages.select_name',[ 'select' => __('messages.handyman') ]).' <span class="text-danger">*</span>',['class'=>'form-control-label'],false)); ?>

                    <br />
                    <?php
                        if($bookingdata->booking_address_id != null)
                        {
                            $route = route('ajax-list', ['type' => 'handyman', 'provider_id' => $bookingdata->provider_id, 'booking_id' => $bookingdata->id ]);
                        } else {
                            $route = route('ajax-list', ['type' => 'handyman', 'provider_id' => $bookingdata->provider_id ]);
                        }
                        $assigned_handyman = $bookingdata->handymanAdded->mapWithKeys(function ($item) {
                            return [$item->handyman_id => optional($item->handyman)->display_name];
                        });
                    ?>
                    <?php echo e(Form::select('handyman_id[]', $assigned_handyman, $bookingdata->handymanAdded->pluck('handyman_id'), [
                            'class' => 'select2js handyman',
                            'id' => 'handyman_id',
                            'required',
                            'data-placeholder' => __('messages.select_name',[ 'select' => __('messages.handyman') ]),
                            'data-ajax--url' => $route,
                        ])); ?>

                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-md btn-secondary" data-dismiss="modal"><?php echo e(trans('messages.close')); ?></button>
            <button type="submit" class="btn btn-md btn-primary" id="btn_submit" data-form="ajax" ><?php echo e(trans('messages.save')); ?></button>
        </div>
        <?php echo e(Form::close()); ?>

    </div>
</div>
<script>
    $('#handyman_id').select2({
        width: '100%',
        placeholder: "<?php echo e(__('messages.select_name',['select' => __('messages.handyman')])); ?>",
    });
</script><?php /**PATH /var/www/html/dashincare/resources/views/booking/assigned_form.blade.php ENDPATH**/ ?>