<?php echo e(Form::hidden('id',$bookingdata->id)); ?>

<?php
$extraValue = 0;
$attachments = optional($bookingdata->service)->getMedia('service_attachment');
if(!$attachments->isEmpty()){
    $image = $attachments[0]->getFullUrl();
} else {
    $image = getSingleMedia(optional($bookingdata->service),'service_attachment');
}
$status = App\Models\BookingStatus::where('status',1)->orderBy('sequence','ASC')->get()->pluck('label', 'value');
unset($status['rejected']);
?>

<div class="card-body p-0">
    <div class="border-bottom pb-3 d-flex justify-content-between align-items-center gap-3 flex-wrap">
        <div>
            <h3 class="c1 mb-2"><?php echo e(__('messages.book_id')); ?> <?php echo e('#' . $bookingdata->id ?? '-'); ?></h3>
            <p class="opacity-75 fz-12">
                <?php echo e(__('messages.book_placed')); ?> <?php echo e($bookingdata->date ?? '-'); ?>

            </p>
        </div>

        <div class="d-flex flex-wrap flex-xxl-nowrap gap-3" data-select2-id="select2-data-8-5c7s">
              
        
            <div class="w3-third">
                <?php if( !(Auth::user()->user_type == 'user' || Auth::user()->user_type == 'freelancer' || Auth::user()->user_type == 'provider') ): ?>
                
                

                <select name="status" class="form-control bookingstatus" data-id="<?php echo e($bookingdata->id); ?>">
                    <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $statusName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e($bookingdata->status === $key ? 'selected' : ''); ?> <?php echo e(Auth::user()->user_type === 'freelance' ? 'disable' : ''); ?>><?php echo e($statusName); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                
                <?php endif; ?>
            </div>
            <div class="w3-third">
                <?php if($bookingdata->handymanAdded->count() == 0): ?>
                    <?php if(auth()->check() && auth()->user()->hasAnyRole('admin|demo_admin')): ?>
                        <a href="<?php echo e(route('booking.assign_form',['id'=> $bookingdata->id ])); ?>" class="float-right btn btn-sm btn-primary loadRemoteModel"><i class="lab la-telegram-plane"></i> <?php echo e(__('messages.assign')); ?></a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <?php if(false): ?>
                <?php if($bookingdata->payment_id !== null): ?>
                <a href="<?php echo e(route('invoice_pdf',$bookingdata->id)); ?>" class="btn btn-primary" target="_blank">
                    <i class="ri-file-text-line"></i>
                    
                    <?php echo e(__('messages.invoice')); ?>

                </a>
                <?php endif; ?>
            <?php endif; ?>
        </div>

    </div>
    <div class="pay-box">
        <div class="pay-method-details">
            <h4 class="mb-2"><?php echo e(__('messages.payment_method')); ?></h4>
            <h5 class="c1 mb-2">
                <?php if($bookingdata->payment && $bookingdata->payment->payment_type === 'atm'): ?>
                    ATM
                <?php elseif($bookingdata->payment && $bookingdata->payment->payment_type === 'credit'): ?>
                    信用卡
                <?php else: ?>
                    未付款
                <?php endif; ?>
            </h5>
            <p><span><?php echo e(__('messages.amount')); ?> : </span><strong><?php echo e(!empty($bookingdata->total_amount) ? getPriceFormat($bookingdata->total_amount): 0); ?></strong></p>
            <?php if($bookingdata->payment && $bookingdata->payment->payment_type === 'atm'): ?>
            <p><span>付款後5碼 : </span><strong><?php echo e($bookingdata->payment->remit_code ? $bookingdata->payment->remit_code : '-'); ?></strong></p>
            <?php endif; ?>
        </div>
        <div class="pay-booking-details">
            
            
            <div class="row mb-2">
                <div class="col-sm-6"> 
                    <span><?php echo e(__('messages.payment_status')); ?> : </span>
                </div>
                <div class="col-sm-6 align-text">  <span class="text-success" id="payment_status__span">
                    <?php if($bookingdata->payment && $bookingdata->payment->payment_type !== 'atm'): ?>
                        <?php echo e(App\Models\Payment::PAYMENT_STATUS[optional($bookingdata->payment)->payment_status]); ?>

                    <?php else: ?>
                        未付款
                    <?php endif; ?>
                </div>
                
            </div>
            <?php if(isset($bookingdata->remit_code)): ?>
            <div class="row mb-2">
                <div class="col-sm-6"> 
                    <span>付款後5碼 : </span>
                </div>
                <div class="col-sm-6 align-text">  
                    <span><?php echo e($bookingdata->remit_code); ?></span>
                </div>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-sm-6"> 
                    <h5>
                        <?php echo e(__('messages.booking_date')); ?> :
                    </h5>
                </div>
                <div class="col-sm-6 align-text"> 
                    <span id="service_schedule__span"><?php echo e($bookingdata->date ?? '-'); ?></span>
                </div>
            </div>
        </div>
    </div>
    <div class="py-3 d-flex gap-3 flex-wrap customer-info-detail mb-2">
        <div class="c1-light-bg radius-10 py-3 px-4 flex-grow-1">
            <h4 class="mb-2"><?php echo e(__('messages.customer_information')); ?></h4>
            <h5 class="c1 mb-3"><?php echo e(optional($bookingdata->customer)->display_name ?? '-'); ?></h5>
            <ul class="list-info">
                <li>
                    <span class="material-icons customer-info-text"><?php echo e(__('messages.phone_information')); ?></span>
                    <a href="" class="customer-info-value">
                        <p class="mb-0"><?php echo e(optional($bookingdata->customer)->contact_number ?? '-'); ?></p>
                    </a>
                </li>
                <li>
                    <span class="material-icons  customer-info-text"><?php echo e(__('messages.address')); ?></span>
                    
                    <p class="customer-info-text"><?php echo e($bookingdata->address); ?></p>
                </li>
            </ul>
        </div>
        <div class="c1-light-bg radius-10 py-3 px-4 flex-grow-1">
            <h4 class="mb-2">
                <?php if(optional($bookingdata->provider)->user_type === 'freelancer'): ?>
                    <?php echo e(__('messages.handyman_information')); ?>

                <?php else: ?>
                    <?php echo e(__('messages.provider_information')); ?>

                <?php endif; ?>
            </h4>
            <h5 class="c1 mb-3">
                <?php echo e(optional($bookingdata->provider)->display_name ?? '-'); ?>

            </h5>
            <ul class="list-info">
                <li>
                    <span class="material-icons customer-info-text"><?php echo e(__('messages.phone_information')); ?></span>
                    <a href="" class="customer-info-value">
                        <p class="mb-0"><?php echo e(optional($bookingdata->provider)->contact_number ?? '-'); ?></p>
                    </a>
                </li>
                <li>
                    <span class="material-icons customer-info-text"><?php echo e(__('messages.address')); ?></span>
                    <p class=" customer-info-value"><?php echo e(optional($bookingdata->provider)->address ?? '-'); ?></p>
                </li>
            </ul>
        </div>
        
        <?php if(optional($bookingdata->provider)->user_type !== 'freelancer'): ?>
        <div class="c1-light-bg radius-10 py-3 px-4 flex-grow-1">
            <?php if(count($bookingdata->handymanAdded) > 0): ?>
            <?php $__currentLoopData = $bookingdata->handymanAdded; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <h4 class="mb-2"><?php echo e(__('messages.handyman_information')); ?></h4>
            <h5 class="c1 mb-3"><?php echo e(optional($booking->handyman)->username ?? '-'); ?></h5>
            <ul class="list-info">
                <li>
                    <span class="material-icons  customer-info-text"><?php echo e(__('messages.phone_information')); ?></span>
                    <a href="" class=" customer-info-value">
                        <p class="mb-0"><?php echo e(optional($booking->handyman)->contact_number ?? '-'); ?></p>
                    </a>
                </li>
                <li>
                    <span class="material-icons  customer-info-text"><?php echo e(__('messages.address')); ?></span>
                    <p  class=" customer-info-value"><?php echo e(optional($booking->handyman)->address ?? '-'); ?></p>
                </li>
            </ul>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <h4 class="mb-2"><?php echo e(__('messages.handyman_information')); ?></h4>
            <h5 class="mb-3">-</h5>
            <ul class="list-info">
                <li>
                    <span class="material-icons  customer-info-text"><?php echo e(__('messages.phone_information')); ?></span>
                    <a href="" class="customer-info-text">
                        <p>-</p>
                    </a>
                </li>
                <li>
                    <span class="material-icons  customer-info-text"><?php echo e(__('messages.address')); ?></span>
                    <p class="customer-info-text">-</p>
                </li>
            </ul>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
    <?php if($bookingdata->bookingExtraCharge->count() > 0 ): ?>
    <h3 class="mb-3 mt-3"><?php echo e(__('messages.extra_charge')); ?></h3>
    <div class="table-responsive border-bottom">
        <table class="table text-nowrap align-middle mb-0">
            <thead>
                <tr>
                    <th class="ps-lg-3"><?php echo e(__('messages.title')); ?></th>
                    <th><?php echo e(__('messages.price')); ?></th>
                    <th><?php echo e(__('messages.quantity')); ?></th>
                    <th class="text-end"><?php echo e(__('messages.total_amount')); ?></th>
                </tr>
            </thead>
            <tbody>
                 <?php $__currentLoopData = $bookingdata->bookingExtraCharge; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chrage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $extraValue += $chrage->price * $chrage->qty;
                        ?>
                    <tr>
                        <td class="text-wrap ps-lg-3">
                            <div class="d-flex flex-column">
                                <a href="" class="booking-service-link fw-bold"><?php echo e($chrage->title); ?></a>
                            </div>
                        </td>
                        <td><?php echo e(getPriceFormat($chrage->price)); ?></td> 
                        <td><?php echo e($chrage->qty); ?></td>
                        <td class="text-end"><?php echo e(getPriceFormat($chrage->price * $chrage->qty)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
    <h3 class="mb-3 mt-3"><?php echo e(__('messages.booking_summery')); ?></h3>
    <div class="table-responsive border-bottom">
        <table class="table text-nowrap align-middle mb-0">
            <thead>
                <tr>
                    <th class="ps-lg-3"><?php echo e(__('messages.service')); ?></th>
                    <th><?php echo e(__('messages.price')); ?></th>
                    <th><?php echo e(__('messages.quantity')); ?></th>
                    <th><?php echo e(__('messages.discount')); ?></th>
                    <th class="text-end"><?php echo e(__('messages.sub_total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-wrap ps-lg-3">
                        <div class="d-flex flex-column">
                            <a href="" class="booking-service-link fw-bold"><?php echo e(optional($bookingdata->service)->name ?? '-'); ?></a>
                        </div>
                    </td>
                    <td><?php echo e(isset($bookingdata->amount) ? getPriceFormat($bookingdata->amount) : 0); ?></td> 
                    <td><?php echo e(!empty($bookingdata->quantity) ? $bookingdata->quantity : 0); ?></td>
                    <td><?php echo e(!empty($bookingdata->discount) ? $bookingdata->discount : 0); ?>%</td>
                    <?php
                    if($bookingdata->service->type === 'fixed'){
                    $sub_total = ($bookingdata->amount) * ($bookingdata->quantity);
                    }else{
                    $sub_total = $bookingdata->amount;
                    }
                    ?>
                    <td class="text-end"><?php echo e(!empty($sub_total) ? getPriceFormat($sub_total) : 0); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="row justify-content-end mt-3">
        <div class="col-sm-10 col-md-6 col-xl-5">
            
        </div>
    </div>
</div>
<script>

$(document).on('change','.bookingstatus', function() {

    var status = $(this).val();

    var id = $(this).attr('data-id');
    $.ajax({
        type: "POST",
        dataType: "json",
        url: "<?php echo e(route('bookingStatus.update')); ?>",
        data: { 'status': status, 'bookingId': id  },
        success: function(data){
            location.reload()
        }
        
    });
})

$(document).on('change','.paymentStatus', function() {

    var status = $(this).val();

    var id = $(this).attr('data-id');
    $.ajax({
        type: "POST",
        dataType: "json",
        url: "<?php echo e(route('bookingStatus.update')); ?>",
        data: { 'status': status, 'bookingId': id  },
        success: function(data){
        }
    });
})
</script>
<?php /**PATH /var/www/html/dashincare/resources/views/booking/info.blade.php ENDPATH**/ ?>