
<?php
    $auth_user= authSession();
?>
<?php echo e(Form::open(['route' => ['question.destroy', $question->id], 'method' => 'delete','data--submit'=>'question'.$question->id])); ?>

<div class="d-flex justify-content-end align-items-center">
    <?php if(!$question->trashed()): ?>
        <?php if($auth_user->can('question edit')): ?>
        <a class="mr-2" href="<?php echo e(route('question.create',['id' => $question->id])); ?>" title="<?php echo e(__('messages.update_form_title',['form' => __('messages.question') ])); ?>"><i class="fas fa-pen text-primary"></i></a>
        <?php endif; ?>

        <?php if($auth_user->can('question delete')): ?>
        <a class="mr-2" href="javascript:void(0)" data--submit="question<?php echo e($question->id); ?>" 
            data--confirmation='true' data-title="<?php echo e(__('messages.delete_form_title',['form'=>  __('messages.question') ])); ?>"
            title="<?php echo e(__('messages.delete_form_title',['form'=>  __('messages.question') ])); ?>"
            data-message='<?php echo e(__("messages.delete_msg")); ?>'>
            <i class="far fa-trash-alt text-danger"></i>
        </a>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(auth()->user()->hasAnyRole(['admin']) && $question->trashed()): ?>
        <a href="<?php echo e(route('question.action',['id' => $question->id, 'type' => 'restore'])); ?>"
            title="<?php echo e(__('messages.restore_form_title',['form' => __('messages.question') ])); ?>"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="<?php echo e(__('messages.restore_form_title',['form'=>  __('messages.question') ])); ?>"
            data-message='<?php echo e(__("messages.restore_msg")); ?>'
            data-datatable="reload"
            class="mr-2">
            <i class="fas fa-redo text-secondary"></i>
        </a>
        <a href="<?php echo e(route('question.action',['id' => $question->id, 'type' => 'forcedelete'])); ?>"
            title="<?php echo e(__('messages.forcedelete_form_title',['form' => __('messages.question') ])); ?>"
            data--submit="confirm_form"
            data--confirmation='true'
            data--ajax='true'
            data-title="<?php echo e(__('messages.forcedelete_form_title',['form'=>  __('messages.question') ])); ?>"
            data-message='<?php echo e(__("messages.forcedelete_msg")); ?>'
            data-datatable="reload"
            class="mr-2">
            <i class="far fa-trash-alt text-danger"></i>
        </a>
    <?php endif; ?>
</div>
<?php echo e(Form::close()); ?><?php /**PATH /var/www/html/dashincare/resources/views/question/action.blade.php ENDPATH**/ ?>