<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class MJapiController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function apiRedirect($method,$url_param1,$url_param2)
    {
    
        //Header
        $API_REQUESTS = Http::withHeaders([]);
        
        $url = 'https://hk.mjlife.com/Gateway/'.$url_param1.'/'.$url_param2;
    
        //需要參數的API
        //客戶資料
        if (strtolower($url_param1) == 'customermanage')
        {
            if (strtolower($url_param2) == 'customer')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sPID' => $_GET['sPID'],
                    ]);
                }
            }
            
            if (strtolower($url_param2) == 'vipd')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sVIPNO' => $_GET['sVIPNO'],
                        'sFAMNO' => $_GET['sFAMNO'],
                    ]);
                }
            }

            if (strtolower($url_param2) == 'vipm')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sVIPNO' => $_GET['sVIPNO'],
                    ]);
                }
            }
        }

        //銷售資料
        if (strtolower($url_param1) == 'salemanage')
        {
            if (strtolower($url_param2) == 'ord')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sOrdNo' => $_GET['sOrdNo'],
                    ]);
                }

                if (strtolower($method) == 'put'){
                    return $API_REQUESTS -> put($url,[
                        'ServerTime' => $_GET['ServerTime'],
                        'content' => $_GET['content'],
                    ]);
                }

            }
            
            if (strtolower($url_param2) == 'getord')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sPID' => $_GET['sPID'],
                        'sCardNo' => $_GET['sCardNo'],
                    ]);
                }
            }
        }

        //商品資料
        if (strtolower($url_param1) == 'productmanage')
        {
            if (strtolower($url_param2) == 'item')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sItemNo' => $_GET['sItemNo'],
                    ]);
                }
            }
        }

        //專案資料
        if (strtolower($url_param1) == 'projectmanage')
        {
            if ((strtolower($url_param2) == 'gethcrece') or
                (strtolower($url_param2) == 'gethcpay'))
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'reslipno' => $_GET['reslipno'],
                    ]);
                }

                if (strtolower($method) == 'post')
                {
                    return $API_REQUESTS-> post($url,[
                        'content' => $_GET['content'],
                    ]);
                }
            }

            if (strtolower($url_param2) == 'getviphc')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sVIPNO' => $_GET['sVIPNO'],
                        'sFAMNO' => $_GET['sFAMNO'],
                    ]);
                }

                if (strtolower($method) == 'post')
                {
                    return $API_REQUESTS-> post($url,[
                        'content' => $_GET['content'],
                    ]);
                }
            }

            if ((strtolower($url_param2) == 'getehcmp') or
                (strtolower($url_param2) == 'gethcase'))
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'sCmpno' => $_GET['sCmpno'],
                    ]);
                }
            }

            if ((strtolower($url_param2) == 'getdaily_new') or
                (strtolower($url_param2) == 'gethci'))
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'shcbranno' => $_GET['shcbranno'],
                    ]);
                }
            }
            
            if (strtolower($url_param2) == 'getehhci')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'scaseno' => $_GET['scaseno'],
                        'hcbranno' => $_GET['hcbranno'],
                    ]);
                }
            }

            if (strtolower($url_param2) == 'getproject')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'ServerTime' => $_GET['ServerTime'],
                        'content' => $_GET['content'],
                    ]);
                }
            }

            if (strtolower($url_param2) == 'getprepay')
            {
                if (strtolower($method) == 'get'){
                    return $API_REQUESTS -> get($url,[
                        'ServerTime' => $_GET['ServerTime'],
                        'accountid' => $_GET['accountid'],
                    ]);
                }
            } 
        }
        
        //不需參數的API
        if (strtolower($method) == 'get'){
            return $API_REQUESTS -> get($url);
        }
        
        if (strtolower($method) == 'post'){
            return $API_REQUESTS -> withbody(
                $_GET['body'],
                "application/json",
            ) -> post($url);
        }

        if (strtolower($method) == 'put'){
            return $API_REQUESTS -> withbody(
                $_GET['body'],
                "application/json",
            ) -> put($url);
        }
        
    }
    
}
