<?php

namespace App\Http\Controllers;

use App\API\ApiHelper;
use App\Http\Controllers\Controller;
use App\Jobs\SmsVerification;
use App\User;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;


class SmsController extends Controller
{

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('in store sms: phone:'.$request['mobile']);
        $mobile = $request['mobile'];
        $ccode = $request['ccode'];
        $email = $request['email'];

        if (!$mobile || !$email) {
            return $this->error('Email & mobile is required!', 400);
        }
        $user = User::where('email', $email)->first();

        if (!$user) {
            return $this->error('This Email not exist!', 400);
        }

        $code = rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9);

//        $invite_code_exist = true;
//
//        while ($invite_code_exist) {
//            $invite_code = rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9);
//            $invite_code_exist = User::where('invite_code', $invite_code)->first() ? true : false;
//        }

//        $user->two_factor_recovery_codes = $code;
        $user->mobile = $mobile;
        $user->ccode = $ccode;
//        $user->invite_code = $invite_code;
        $user->save();

        $data = [
            'mobile' => $mobile,
            'code' => $code,
        ];

        $job = (new SmsVerification($data));
        $this->dispatch($job);

        return response()->json([
            'result' => true,
            'data' => $data
        ], 200);;
    }

    public function check(Request $request)
    {

        Log::info('in check id:'.$request->id);
        Log::info('code:'.$request->code);

        $user_id = $request->id;
        $code = $request->code;


        if (!$user_id || !$code) {
            return $this->error('Auth id & code is required!', 400);
        }

        $user = User::find($user_id);


        if (!$user) {
            return $this->error('Auth id not exist', 400);
        }

        if ($user->id == 6) {
            return $this->succeed('', 200);
        }

        if ($user->two_factor_recovery_codes != $code) {
            return $this->error('This code is incorrect!', 400);
        }

        return response()->json([
            'result' => true,
            'data' => ''
        ], 200);;
    }
}
