<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class TradevanController extends Controller
{
	
    //GC_vic:2022-03-17 關貿付款
	public function payment(Request $request){
		$payment_data = $request->all();
		
		$payment_url = $payment_data['payment_url'];
		unset($payment_data['payment_url']);
		
		//送出
		$response = Http::withHeaders([
			'version' => '1.03'
		])->asForm()->post($payment_url, $payment_data);
		
		//回傳導向付款Html
		return $response->body();
	}
	
	//GC_vic:2022-03-22 關貿發票
	public function invoice(Request $request){
		$input = $request->all();
		
		$request_url = $input['request_url'];
		unset($input['request_url']);
		
		//送出
		$response = Http::asForm()->post($request_url, $input['data']);
		
		//回傳導向付款Html
		return $response->json();
	}
	
	
}
