<?php


namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SmsVerification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data;

    public $tries = 1;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $code = (string)$this->data['code'];
        $mobile = (string)$this->data['mobile'];
        Log::info('in sms job: phone:' . $mobile);
        $message = $code . '是您的簡訊驗證碼。';
        $username = 'vance';
        $password = '123456';
//        企業帳號 (三站)
//https://smsapi.mitake.com.tw/api/mtk/SmSend?

//個人帳號 (二站)
//http://smsb2c.mitake.com.tw/b2c/mtk/SmSend?
        $curl = curl_init();
        $url = 'http://smsb2c.mitake.com.tw/b2c/mtk/SmSend?username=' . $username . '&password=' . $password . '&dstaddr=' . $mobile . '&smbody=' . $message . '&CharsetURL=UTF-8';

        $data = 'username=' . $username;
        $data .= '&password=' . $password;
        $data .= '&dstaddr=' . $mobile;
        $data .= '&smbody=' . $message;

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/x-www-form- urlencoded"));
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        $output = curl_exec($curl);
        curl_close($curl);
        Log::info('output:[' . print_r($output) . ']');
        echo $output;
    }
}
