<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::namespace('Api')->group(function () {
    Route::post('sms', [Controllers\SmsController::class, 'store']);
    Route::post('sms/check', [Controllers\SmsController::class, 'check']);
});

Route::middleware('auth:api', 'scopes:view-user')->get('/user', function (Request $request) {
    return $request->user();
});

//MJ_API
Route::get('/{method}/{url1}/{url2}','MJapiController@apiRedirect');